//
//  MCListView.h
//  ListView
//
//  Created by Mark Onyschuk on 11/05/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class ECBinder;
@class MCListRow;
@class MCListHeaderView;

@interface MCListView : NSControl {
	NSMutableArray		*_rows;
	float				_rowHeight;
	
	BOOL				_usesHeader;
	MCListHeaderView	*_headerView;
	MCListHeaderView	*_cornerView;
	
	BOOL				_usesAlternatingRowBackgroundColors;
	
	ECBinder			*_binder;	
	
	id					_target;
	SEL					_action;
	SEL					_doubleAction;
	
	id					_delegate;
	
	IBOutlet MCListRow	*rowTemplate;
	IBOutlet NSView		*emptyContainerContentView;
}

#pragma mark -
#pragma mark Accessors
- (NSArray *)rows;
- (void)setRows:(NSArray *)anArray;

- (NSArray *)selectedRows;
- (void)setSelectedRows:(NSArray *)anArray;

- (float)rowHeight;
- (void)setRowHeight:(float)aHeight;

- (BOOL)usesHeader;
- (void)setUsesHeader:(BOOL)aBool;

- (BOOL)usesAlternatingRowBackgroundColors;
- (void)setUsesAlternatingRowBackgroundColors:(BOOL)aBool;

- (NSView *)emptyContainerContentView;
- (void)setEmptyContainerContentView:(NSView *)aView;

- (id)target;
- (void)setTarget:(id)aTarget;

- (SEL)action;
- (void)setAction:(SEL)anAction;

- (SEL)doubleAction;
- (void)setDoubleAction:(SEL)anAction;

- (id)delegate;
- (void)setDelegate:(id)aDelegate;

#pragma mark -
#pragma mark Layout

- (void)tileWithAdded:(NSArray *)added removed:(NSArray *)removed changed:(BOOL)didChange;

- (MCListRow *)rowTemplate;
- (void)setRowTemplate:(MCListRow *)aRow;

- (void)rebuildRows;
- (void)updateRow:(id)aRow forObject:(id)anObject;

#pragma mark -
#pragma mark Event Handling
- (BOOL)acceptsFirstResponder;
- (void)keyDown:(NSEvent *)theEvent;

#pragma mark -
#pragma mark Drawing

- (BOOL)isOpaque;
- (BOOL)isFlipped;

- (void)drawRect:(NSRect)theRect;

#pragma mark -
#pragma mark Cocoa Bindings

+ (void)initialize;

- (void)bind:(NSString *)aBinding toObject:(id)anObject withKeyPath:(NSString *)aKeyPath options:(NSDictionary *)aDictionary;
- (void)unbind:(NSString *)binding;

- (void)binder:(ECBinder *)sender didObserveChangeInBinding:(NSString *)aBinding;
	
@end

@interface MCListView (MCListViewPrivate)
- (void)setState:(BOOL)aState forRow:(MCListRow *)aRow;
- (void)setSelectedStateForRow:(MCListRow *)aRow withEvent:(NSEvent *)theEvent;
@end

@interface NSObject (MCListViewDelegate)
- (void)listView:(MCListView *)aView willReturnRow:(MCListRow *)aRow;
- (BOOL)listView:(MCListView *)aView shouldDeleteRow:(MCListRow *)aRow;

- (unsigned)listView:(MCListView *)aView countForRow:(MCListRow *)aRow;
- (NSImage *)listView:(MCListView *)aView imageForRow:(MCListRow *)aRow;
- (BOOL)listView:(MCListView *)aView shouldSetState:(BOOL)aState forRow:(MCListRow *)aRow;

- (BOOL)listView:(MCListView *)aView shouldSelectSubview:(NSView *)aView;
@end
